<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Team extends Model 
{

    protected $table = 'teams';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'logo', 'customer_id');

    public function customer()
    {
        return $this->belongsTo('App\Model\Customer');
    }

    public function drivers()
    {
        return $this->hasMany('App\Model\Actor');
    }

}